import React from 'react';
import { MAIL_TYPE } from './constants';
import ActionsDefault from './ActionsDefault';
import ActionsDraft from './ActionsDraft';
import ActionsDelayed from './ActionsDelayed';

const Actions = ({ type, ...other }) => {
  if (MAIL_TYPE.DRAFT === type) {
    return <ActionsDraft {...other} />;
  }

  if (MAIL_TYPE.DELAYED === type) {
    return <ActionsDelayed {...other} />;
  }

  return <ActionsDefault {...other} />;
};

export default Actions;
