import React, { useContext } from 'react';
import MoveToFolder from 'pages/mail/containers/MoveToFolder';
import createI18N from '@yandex-int/i18n';
import { MediaMatchContext, DeviceType } from 'components/MediaMatch';
import Dropdown2 from 'lego/components/Dropdown2';
import * as commonKeyset from 'common.i18n';
import * as keyset from './Actions.i18n';
import css from './actions.modules.scss';
import Button from './ActionButton';

const i18n = createI18N(keyset);
const i18nReply = i18n('reply');
const i18nReplyAll = i18n('replyAll');
const i18nForward = i18n('forward');
const i18nRemove = createI18N(commonKeyset)('remove');
const i18nNotSpam = i18n('notSpam');
const i18nSpam = i18n('spam');
const i18nRead = i18n('read');
const i18nNotRead = i18n('notRead');
const i18nMoveToFolder = i18n('moveToFolder');
const i18nActions = i18n('actions');

const ActionsDefault = ({
  onReply,
  onReplyAll,
  onForward,
  onRemove,
  onSpam,
  onUnread,
  isUnread,
  isSpam,
  mailId,
}) => {
  const deviceType = useContext(MediaMatchContext);

  const actions = (
    <>
      {onReply && (
        <Button iconColor="blue" onClick={onReply} icon="mainToolbarReply">
          {i18nReply}
        </Button>
      )}
      {onReplyAll && (
        <Button iconColor="blue" onClick={onReplyAll} icon="mainToolbarReply">
          {i18nReplyAll}
        </Button>
      )}
      {onForward && (
        <Button iconColor="green" onClick={onForward} icon="mainToolbarForward">
          {i18nForward}
        </Button>
      )}
      {onRemove && (
        <Button iconColor="red" onClick={onRemove} icon="mainToolbarDelete">
          {i18nRemove}
        </Button>
      )}
      {onSpam && (
        <Button iconColor="orange" onClick={() => onSpam(!isSpam)} icon="mainToolbarSpam">
          {isSpam ? i18nNotSpam : i18nSpam}
        </Button>
      )}
      {onUnread && (
        <Button
          iconColor="blue"
          onClick={() => onUnread(!isUnread)}
          icon={isUnread ? 'mainToolbarRead' : 'mainToolbarUnread'}
        >
          {isUnread ? i18nRead : i18nNotRead}
        </Button>
      )}
      <MoveToFolder mailId={mailId}>
        <Button iconColor="blue" icon="mainToolbarFolder">
          {i18nMoveToFolder}
        </Button>
      </MoveToFolder>
    </>
  );

  const desktop = <div className={css.wrap}>{actions}</div>;

  const phone = (
    <div>
      <Dropdown2>
        <Dropdown2.Button cls={css.dropdown}>{i18nActions}</Dropdown2.Button>
        <Dropdown2.Popup clsWrap={css.dropdown__popup} directions={['bottom']}>
          {actions}
        </Dropdown2.Popup>
      </Dropdown2>
    </div>
  );

  return <div className={css.root}>{deviceType === DeviceType.Phone ? phone : desktop}</div>;
};

export default ActionsDefault;
