import React from 'react';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import * as keyset from './Actions.i18n';
import css from './actions.modules.scss';
import Button from './ActionButton';

const i18nOpenDraft = createI18N(keyset)('openDraft');
const i18nRemove = createI18N(commonKeyset)('remove');

const ActionsDraft = ({ onDraft, onRemove }) => (
  <div className={css.root}>
    <div className={css.wrap}>
      {onDraft && (
        <Button iconColor="blue" onClick={onDraft} icon="mainToolbarReply">
          {i18nOpenDraft}
        </Button>
      )}
      {onRemove && (
        <Button iconColor="red" onClick={onRemove} icon="mainToolbarDelete">
          {i18nRemove}
        </Button>
      )}
    </div>
  </div>
);

export default ActionsDraft;
