import React from 'react';
import Tags from 'pages/mail/components/Tags';
import { getTagsName } from 'pages/mail/selectors';
import cx from 'classnames';
import { Important } from '../../../indicators';
import css from './header.modules.scss';

const Header = (args) => {
  const {
    className,
    id,
    files: Files,
    info: Info,
    tags,
    isImportant,
    props,
  } = args;

  const tagsName = getTagsName(id);

  return (
    <div className={cx(className, css.root)}>
      <Important
        className={css.important}
        mailId={id}
        isImportant={isImportant}
        readonly={props.readonly}
      />
      <Info />
      <Tags
        className={css.tags}
        name={tagsName}
        id={id}
        tags={tags}
        canEdit={!props.readonly}
      />
      <Files />
    </div>
  );
};

export default Header;
