import React from 'react';
import Popup from '@crm/components/dist/lego2/Popup';
import ContactPopupContainer from '../../containers/popupDecorator';

const directions = ['right-top'];

const fromPopupDecorator = ({ mailId, modalFormNameSelect, onCreateContact }) => {
  const MailContactPopup = (fromNode) => {
    if (!fromNode) {
      return null;
    }
    return (
      <Popup visible target="anchor" anchor={fromNode} directions={directions} hasTail>
        <ContactPopupContainer
          mailId={mailId}
          onCreateContact={onCreateContact}
          modalFormNameSelect={modalFormNameSelect}
        />
      </Popup>
    );
  };

  return MailContactPopup;
};

export default fromPopupDecorator;
