import React from 'react';
import PropTypes from 'prop-types';
import createI18N from '@yandex-int/i18n';
import * as commonKeyset from 'common.i18n';
import Button from '@crm/components/dist/lego2/Button';
import cx from 'classnames';
import * as keyset from './MailPreview.i18n';
import css from './styles.modules.scss';

const commonI18n = createI18N(commonKeyset);
const i18n = createI18N(keyset);
const i18nNoContactInAccount = i18n('noContactInAccount');
const i18nCreate = commonI18n('create');
const i18nAdd = commonI18n('add');
const i18nClose = commonI18n('close');

const ContactPopup = ({
  modalFormNameNew,
  modalFormNameSelect,
  onAcceptNew,
  onAcceptSelect,
  onDecline,
}) => (
  <div className={css.popupContent}>
    <div className={css.popupMessage}>{i18nNoContactInAccount}</div>
    <div className={css.popupControls}>
      <Button
        className={css.popupButton}
        size="xs"
        onClick={() => onAcceptNew(modalFormNameNew)}
        pin="round-brick"
        view="pseudo"
      >
        {i18nCreate}
      </Button>
      <Button
        className={css.popupButton}
        size="xs"
        onClick={() => onAcceptSelect(modalFormNameSelect)}
        pin="clear-round"
        view="pseudo"
      >
        {i18nAdd}
      </Button>
      <Button className={cx(css.popupButton, css.close)} size="xs" onClick={onDecline} view="clear">
        {i18nClose}
      </Button>
    </div>
  </div>
);

ContactPopup.propTypes = {
  modalFormNameNew: PropTypes.string.isRequired,
  modalFormNameSelect: PropTypes.string.isRequired,
  onAcceptNew: PropTypes.func.isRequired,
  onAcceptSelect: PropTypes.func.isRequired,
  onDecline: PropTypes.func.isRequired,
};

export default ContactPopup;
