import React from 'react';
import PropTypes from 'prop-types';
import ContactSelectFormModal from 'modules/contactSelectForm';

const AddContactModal = (props) => {
  const { formName, account, ...passPropsThrough } = props;

  if (!account || !account.id) {
    return null;
  }

  return (
    <ContactSelectFormModal
      name={formName}
      accountId={account.id}
      {...passPropsThrough}
    />
  );
};

AddContactModal.propTypes = {
  formName: PropTypes.string.isRequired,
  account: PropTypes.shape({
    id: PropTypes.number.isRequired,
  }).isRequired,
};

export default AddContactModal;
