import { connect } from 'react-redux';
import get from 'lodash/get';
import mapValues from 'lodash/mapValues';
import loader from 'hoc/loader';
import destroyDriver from 'utils/destroyDriver';
import dataChanger from 'utils/dataChanger';
import { bindActionCreators } from 'redux';
import * as actions from '../actions';
import { getState } from '../selectors';
import MailPreview from '../components/MailPreview';

const mapState = (state, props) => ({
  ...getState(state, props.mailId),
});

const mapDispatch = (dispatch, props) => {
  const replyAction = (mailId, isReplyAll) =>
    props.onReply({ replyToMailId: mailId, isFwd: false, isReplyAll });
  const bindName = actionCreator => actionCreator.bind(null, props.mailId);
  const boundListACs = mapValues(actions, bindName);
  const connectedBoundListACs = bindActionCreators(boundListACs, dispatch);

  return {
    dispatch,
    onReply: () => replyAction(props.mailId),
    onReplyAll: () => replyAction(props.mailId, true),
    onForward: () => props.onReply({ replyToMailId: props.mailId, isFwd: true }),
    onDraft: () => props.onDraft({ mailId: props.mailId }),
    // onMount: connectedBoundListACs.load,
    onMount: () => {
      dispatch(actions.load(props.mailId))
        .then((response) => {
          if (response && response.data && response.data.account) {
            dispatch(actions.checkKik(props.mailId, response.data.account.id));
          }
        });
    },
    onUnmount: connectedBoundListACs.destroy,
    onReceiveProps: (nextProps, currentProps) => {
      if (nextProps.mailId && (nextProps.mailId !== currentProps.mailId)) {
        dispatch(actions.load(nextProps.mailId))
          .then((response) => {
            if (response && response.data && response.data.account) {
              dispatch(actions.checkKik(nextProps.mailId, response.data.account.id));
            }
          });

        if (currentProps.destroyOnUnmount) {
          dispatch(actions.destroy(currentProps.mailId));
        }
      }

      if ((nextProps.mailId === undefined) && (nextProps.mailId !== currentProps.mailId)) {
        dispatch(actions.destroy(currentProps.mailId));
      }
    },
    ...connectedBoundListACs,
  };
};

const mapMerge = (stateProps, dispatchProps, ownProps) => ({
  ...ownProps,
  ...stateProps,
  ...dispatchProps,
  commentSave: (formValues) => {
    let values;
    const commentId = get(stateProps, 'data.comment.id');
    if (commentId) {
      values = { commentId, ...formValues };
    } else {
      values = { mailId: get(stateProps, 'data.mail.id'), ...formValues };
    }

    return dispatchProps.commentSave(values);
  },
  setImportant: () => dispatchProps.setImportant(!get(stateProps, 'data.mail.isImportant')),
  commentRemove: () => dispatchProps.commentRemove(get(stateProps, 'data.comment.id')),
  setAccount: client => {
    dispatchProps.setAccount(client.id)
      .then(() => dispatchProps.dispatch(actions.checkKik(get(stateProps, 'data.mail.id'), client.id)));
  },
});

export default connect(mapState, mapDispatch, mapMerge)(
  destroyDriver({ slugName: 'mailId' })(loader()(dataChanger()(MailPreview))),
);
