import { connect } from 'react-redux';
import { toggle } from 'containers/Modal';
import * as actions from '../actions';
import popupBody from '../components/MailPreview/popupBody';

const mapDispatch = (dispatch, props) => ({
  onAcceptNew: () => {
    props.onCreateContact();
    dispatch(actions.hidePopup(props.mailId));
  },
  onAcceptSelect: modalFormNameSelect => {
    dispatch(toggle(modalFormNameSelect, true));
    dispatch(actions.hidePopup(props.mailId));
  },
  onDecline: () => dispatch(actions.hidePopup(props.mailId)),
});

export default connect(
  null,
  mapDispatch,
)(popupBody);
