import Immutable, { List } from 'immutable';
import arrayReducerFactory from 'utils/reducer/arrayReducerFactory';
import * as aTypes from './actionTypes';

const preview = {
  [aTypes.LOAD_REQUEST](state) {
    return state.set('isFetch', true);
  },
  [aTypes.LOAD_RECEIVE](state, { data }) {
    return state.delete('isFetch').set('isLoad', true).set('data', Immutable.fromJS(data));
  },
  [aTypes.LOAD_FAIL](state) {
    return state.delete('isFetch');
  },
  [aTypes.COMMENT_SAVE_RECEIVE](state, { data }) {
    return state.setIn(['data', 'comment'], Immutable.fromJS(data.comment));
  },
  [aTypes.COMMENT_REMOVE_RECEIVE](state) {
    return state.removeIn(['data', 'comment']);
  },
  [aTypes.UPDATE](state, { payload }) {
    return state.mergeDeepIn(['data'], payload);
  },
  [aTypes.ADD_REQUEST](state, { payload }) {
    const path = ['data', 'requests'];
    let requests = state.getIn(path);
    if (!List.isList(requests)) {
      requests = Immutable.fromJS([]);
    }
    requests = requests.push(payload);
    return state.setIn(path, requests);
  },
  [aTypes.KIK_CHECK_RECEIVE](state, { data }) {
    if (data) {
      data.showPopup = true;
    }
    return state.setIn(['data', 'mail', 'contact'], data);
  },
  [aTypes.HIDE_FROM_POPUP](state) {
    return state.setIn(['data', 'mail', 'contact', 'showPopup'], false);
  },
};

export default arrayReducerFactory(aTypes, preview);
