import { makeAutoObservable } from 'mobx';
import { jsonApiCall } from 'api/common';
import {
  OpportunityDTO,
  OpportunityResponseDTO,
  MailOpportunitiesResponse,
  MailOpportunityLinkFormRequestData,
} from './Opportunities.types';
import { OpportunitiesService } from './Opportunities.types';

export class OpportunitiesServiceImpl implements OpportunitiesService {
  private mailId: number;
  public opportunities: OpportunityDTO[] = [];

  constructor(mailId: number) {
    this.setMailId(mailId);

    makeAutoObservable(this, undefined, { autoBind: true });
  }

  public setMailId = (mailId: number) => {
    this.mailId = mailId;
  };

  public setOpportunities = (opportunities: OpportunityResponseDTO[]) => {
    this.opportunities = opportunities.map((el) => ({
      id: String(el.id),
      name: el.name,
    }));
  };

  public save = (data: OpportunityDTO[]) => {
    const opportunities = data.map((el) => ({
      id: parseInt(el.id),
      name: el.name,
    }));

    jsonApiCall<MailOpportunityLinkFormRequestData, MailOpportunitiesResponse>({
      url: `/issue/linkMail`,
      data: {
        mailId: this.mailId,
        opportunities,
      },
    }).then((res) => {
      this.setOpportunities(res.opportunities);
    });
  };
}
