import { Account } from 'types';

export interface OpportunityResponseDTO {
  id: number;
  name: string;
}

export interface OpportunityDTO {
  id: string;
  name: string;
}

export interface OpportunitiesService {
  opportunities: OpportunityDTO[];
  save: (value: OpportunityDTO[]) => void;
}

export interface OpportunitiesProps {
  className?: string;
  headerClassName?: string;
  bodyClassName?: string;
  actionClassName?: string;
  itemClassName?: string;
  opportunitiesService: OpportunitiesService;
  readonly?: boolean;
  account?: Account;
  mailId?: number;
}

export interface MailOpportunitiesResponse {
  opportunities: OpportunityResponseDTO[];
  noLinkWithOpportunity: boolean;
}

export interface MailOpportunityLinkFormRequestData {
  mailId: number;
  opportunities: OpportunityResponseDTO[];
}
