import React, { FC } from 'react';
import createLink from 'modules/issues/utils/createLink';
import { LinkWithText } from '../../../components/LinkWithText';
import { OpportunityProps } from './Opportunity.types';

const OPPORTYNITY_TYPE_ID = 6;

export const Opportunity: FC<OpportunityProps> = ({ className, opportunity }) => {
  const issueLink = createLink({ hash: false, id: opportunity.id, typeId: OPPORTYNITY_TYPE_ID });

  return (
    <LinkWithText
      className={className}
      url={issueLink}
      linkText={opportunity.id}
      text={opportunity.name}
    />
  );
};
