/* eslint-disable jsx-a11y/anchor-is-valid */

import React from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';
import cx from 'classnames';
import createLink from 'modules/issues/utils/createLink';
import { IssueType } from 'modules/issues/types';
import cssChips from 'styles/component/chips.scss';
import css from './Request.scss';

const Request = ({ className, issueId, id, category, state }) => {
  const linkText = `${issueId || id}`;
  let text = `(${state.name})`;
  if (category && category.name) {
    text += ` - ${category.name}`;
  }

  return (
    <div className={cx(className, css.b)} title={`${linkText} ${text}`}>
      <Link
        to={createLink({ id: issueId || id, typeId: IssueType.Ticket, hash: false })}
        target="_blank"
      >
        {linkText}
      </Link>
      <span className={cssChips.chip__title}>{text}</span>
    </div>
  );
};

Request.propTypes = {
  className: PropTypes.string,
  requestId: PropTypes.number.isRequired,
  requestNumber: PropTypes.number,
  category: PropTypes.shape({
    name: PropTypes.string,
  }).isRequired,
  state: PropTypes.shape({
    name: PropTypes.string,
  }).isRequired,
};

Request.defaultProps = {
  className: undefined,
  requestNumber: undefined,
};

export default Request;
