import React, { useCallback } from 'react';
import PropTypes from 'prop-types';
import createI18N from '@yandex-int/i18n';
import { modal as createSecondLineTicket, AppModuleString } from 'modules/requestForm2';
import { ETypeString } from 'types/entities';
import Button from '@crm/components/dist/lego2/Button';
import * as keyset from './requests.i18n';
import Request from './Request';

const i18n = createI18N(keyset);
const i18nTickets = i18n('tickets');
const i18nCreate = i18n('create');

const Requests = ({
  className,
  headerClassName,
  bodyClassName,
  actionClassName,
  itemClassName,
  items,
  mailId,
  readonly,
  addRequest,
}) => {
  const createRequest = useCallback(() => {
    createSecondLineTicket.open({
      data: {
        data: { mailId, byEObject: { eid: mailId, etype: ETypeString.Mail } },
        context: { module: AppModuleString.PersonalMail, action: 'personalMail' },
      },
      onSubmitSuccess: addRequest,
    });
  }, [addRequest, mailId]);

  return (
    <div className={className}>
      <span className={headerClassName}>
        {i18nTickets}
        {!readonly && (
          <span className={actionClassName}>
            <Button size="xs" view="pseudo" onClick={createRequest}>
              {i18nCreate}
            </Button>
          </span>
        )}
      </span>
      {Boolean(items.length) && (
        <div className={bodyClassName}>
          {items.map((item) => (
            <Request key={item.issueId || item.id} className={itemClassName} {...item} />
          ))}
        </div>
      )}
    </div>
  );
};

Requests.defaultProps = {
  items: [],
  className: null,
  headerClassName: null,
  bodyClassName: null,
  actionClassName: null,
  itemClassName: null,
  readonly: false,
};

Requests.propTypes = {
  className: PropTypes.string,
  headerClassName: PropTypes.string,
  bodyClassName: PropTypes.string,
  actionClassName: PropTypes.string,
  itemClassName: PropTypes.string,
  items: PropTypes.arrayOf(PropTypes.object),
  mailId: PropTypes.number.isRequired,
  readonly: PropTypes.bool,
  addRequest: PropTypes.func.isRequired,
};

export default Requests;
