import React from 'react';
import { RouteComponentProps } from 'react-router-dom';
import { createAuthorizationComponent } from 'modules/authorization/moduleAuthorization';
import TitleChain from 'modules/heading';
import { MODULE_NAME } from './constants';
import LazyLayout from './lazy/LazyLayout';

const Auth = createAuthorizationComponent('mail');

interface RouterParams {
  param1?: string;
  param2?: string;
  param3?: string;
  param4?: string;
}

const adapterRouterV3toV4 = (props: RouteComponentProps<RouterParams>) => {
  const newParams = {};
  const { param1, param2, param3, param4 } = props.match.params;
  if (param1 !== 'new') {
    if (param1) {
      newParams[param1] = param2;
    }

    if (param3) {
      newParams[param3] = param4;
    }
  }

  return { ...props, params: newParams };
};

const MailRouter: React.FC<RouteComponentProps<RouterParams>> = props => {
  const routeProps = adapterRouterV3toV4(props);

  return (
    <Auth>
      <TitleChain>{MODULE_NAME}</TitleChain>
      <LazyLayout {...routeProps} />
    </Auth>
  );
};

export default MailRouter;
