import mapValues from 'lodash/mapValues';
import get from 'lodash/get';
import { update as updateTreeSelect } from 'containers/TreeSelect/actions';
import { selectors, actions } from 'containers/InfiniteList';
import { getActiveFilter, getFilter } from 'modules/filter';
import { List } from 'immutable';
import { update as mailPreviewUpdate } from './modules/mailPreview';
import { NAME, LIST_SETTINGS_NAME } from './constants';
import redux from './redux';

const getCurrentMailId = () => {
  let mailId;

  try {
    mailId = parseInt(window.location.href.match(/mailId\/(\d+)/)[1], 10);
  } catch (e) {} // eslint-disable-line no-empty

  return mailId;
};

const getId = (item = {}) => {
  if (typeof item.get === 'function') {
    return item.get('id');
  }

  return item.id;
};

export const preview = {
  context: NAME,
  key: 'preview',
  getContextArgs: state => {
    const mailId = getCurrentMailId(state);
    if (!mailId) {
      return undefined;
    }

    return { mailId };
  },
  update: (update, dispatch, state) => {
    if (update && update.mail && getCurrentMailId(state) === update.mailId) {
      dispatch(mailPreviewUpdate(update.mailId, update.mail));
    }
  },
};

export const list = {
  context: NAME,
  key: 'list',
  getContextArgs: state => {
    let mailIds;
    try {
      mailIds = selectors.getState(state, NAME).items.map(item => item.id);
    } catch (e) {} // eslint-disable-line no-empty

    let filter;
    try {
      filter = getActiveFilter(state, NAME).value;
    } catch (e) {} // eslint-disable-line no-empty

    let thread;
    try {
      ({ thread } = getFilter(state, NAME, LIST_SETTINGS_NAME).value);
    } catch (e) {} // eslint-disable-line no-empty

    if (filter || mailIds) {
      return {
        filter,
        thread,
        mailIds,
      };
    }

    return undefined;
  },
  update: (updateObj = {}, dispatch) => {
    const { remove, update, add } = updateObj;

    const isRemove = Array.isArray(remove);
    const isUpdate = Array.isArray(update);
    const isAdd = Array.isArray(add);

    if (isRemove || isUpdate || isAdd) {
      dispatch(
        actions.update(NAME, state => {
          let items = state.get('items') || List();

          // remove items
          if (isRemove) {
            remove.forEach(removeId => {
              items = items.filter(mail => mail.get('id') !== removeId);
            });
          }

          // update items
          if (isUpdate) {
            update.forEach(updateForItem => {
              let index = -1;

              items.valueSeq().forEach(item => {
                index += 1;
                return item.get('id') !== updateForItem.id;
              });

              items = items.mergeDeepIn([index.toString()], updateForItem);
            });
          }

          // add items
          if (isAdd) {
            let index = 0;
            add.forEach(addItem => {
              const insertAfterId = addItem.insertAfterId; // eslint-disable-line prefer-destructuring
              if (!insertAfterId) {
                items = items.insert(0, addItem.item);
              } else {
                // search index of element for insert after
                while (index < items.size && getId(items.get(index)) !== insertAfterId) {
                  index += 1;
                }

                // insert after searched element
                index += 1;
                items = items.insert(index, addItem.item);
              }
            });
          }

          return state.set('items', items);
        }),
      );
    }
  },
};

export const folder = {
  context: NAME,
  key: 'folder',
  getContextArgs: () => true,
  update: (updateObj, dispatch) => {
    if (updateObj) {
      const unread = get(updateObj, 'summaryCounter.unread');
      if (typeof unread === 'number') {
        dispatch(redux.actions.updateUnread(unread));
      }
      dispatch(
        updateTreeSelect(NAME, state =>
          state.mergeIn(['data'], updateObj).mergeDeepIn(
            ['list'],
            mapValues(updateObj.items, obj => ({ counter: obj })),
          ),
        ),
      );
    }
  },
};
