import React from 'react';
import RouterLink from 'components/RouterLink';
import TitleChain from 'modules/heading';
import { PATH } from 'modules/requestForm2';
import css from './styles.modules.scss';

const ErrorPage = () => (
  <div className={css.wrap}>
    <TitleChain>Страница не найдена</TitleChain>
    <div className={css.wrapSplash}>
      <div className={css.textBlock}>
        <h1 className={css.title}>404</h1>
        <h2 className={css.subTitle}>Страница не найдена</h2>
      </div>
      <div className={css.splash} />
    </div>
    <ul className={css.nav}>
      <li className={css.navItem}>
        <RouterLink to="/">На главную</RouterLink>
      </li>
      <li className={css.navItem}>
        <RouterLink to={PATH}>Создать заявку</RouterLink>
      </li>
    </ul>
  </div>
);

export default ErrorPage;
