import React from 'react';
import lazilyLoadComponent from 'utils/LazilyLoad/lazilyLoadComponent';
import { createAuthorizationComponent } from 'modules/authorization/moduleAuthorization';
import TitleChain from 'modules/heading';
import { AUTHORIZATION_NAME } from 'modules/review/constants';

const Auth = createAuthorizationComponent(AUTHORIZATION_NAME);
const Review = lazilyLoadComponent(() => import('modules/review'));
const ReviewItem = lazilyLoadComponent(() => import('modules/review/components/Item'));

const ReviewRouter = ({ match, location }) => (
  <Auth>
    <TitleChain>Ревью</TitleChain>
    <Review params={match.params} location={location}>
      <ReviewItem />
    </Review>
  </Auth>
);

export default ReviewRouter;
