import { ReducersMapObject } from '@reduxjs/toolkit';
import combineReducers from 'utils/reducer/combineReducers';
import { reducer as formReducer } from 'redux-form';
import { reducer as fileViewer } from 'components/FileViewer';
import { reducer as iframe, NAME as iframeName } from 'components/Iframe';
import currencyReducer, { SLICE_NAME as CURRENCY_SLICE_NAME } from 'modules/currencySwitch';
import {
  reducer as accountFinanceReducer,
  SLICE_NAME as ACCOUNT_FINANCE_SLICE_NAME,
} from 'pages/accounts/modules/info/modules/finance';
import status, { NAME as statusName } from 'modules/userStatus';
import issuePreviewReducer from 'modules/issuePreview/redux/previewSlice';
import UISettingsReducer from 'entry/modules/initial/UiSettings/reducer';
import { INIT_STORAGE } from 'entry/modules/initial/actionTypes';
import treeView from 'dialogs/TreeView';
import { reducer as infiniteReducer } from 'containers/InfiniteList';
import { NAME as treeSelectSliceName } from 'containers/TreeSelect/constants';
import treeSelectReducer from 'containers/TreeSelect/reducer';
import queueList from './queue-list';
import ui from './ui';
import moduleCounters from './moduleCountersSlice';

export { moduleCounters };
export default function createReducer(asyncReducers?: ReducersMapObject) {
  const common = combineReducers({
    queueList,
    ui,
    UISettings: UISettingsReducer,
    infiniteList: infiniteReducer,
    form: formReducer,
    moduleCounters: moduleCounters.reducer,
    fileViewer,
    [treeSelectSliceName]: treeSelectReducer,
    [iframeName]: iframe,
    [CURRENCY_SLICE_NAME]: currencyReducer,
    [ACCOUNT_FINANCE_SLICE_NAME]: accountFinanceReducer,
    [statusName]: status,
    [treeView.constants.NAME]: treeView.reducer,
    issuePreview: issuePreviewReducer,
    ...asyncReducers,
  });

  return (state = {}, action) => {
    if (action.type === INIT_STORAGE) {
      return { ...state, ...action.payload };
    }

    return { ...state, ...common(state as ReturnType<typeof common>, action) };
  };
}
