import { createSlice, PayloadAction } from '@reduxjs/toolkit';

interface State {
  [module: string]: number;
}

enum modules {
  mail = 'mail',
  notifications = 'notifications',
  issue = 'issue',
}
const NAME = 'moduleCounters';
const initialState = {
  [modules.issue]: 0,
  [modules.notifications]: 0,
  [modules.mail]: 0,
};

export interface SetPayload {
  [module: string]: number;
}

export const moduleCounters = createSlice({
  name: NAME,
  initialState,
  reducers: {
    set: (state, action: PayloadAction<SetPayload>) => {
      return {
        ...state,
        ...action.payload,
      };
    },
    increment: (state, action: PayloadAction<string>) => {
      const module = action.payload;
      if (state[module] == null) {
        return state;
      }

      return {
        ...state,
        [module]: state[module] + 1,
      };
    },
    decrement: (state, action: PayloadAction<string>) => {
      const module = action.payload;
      if (state[module] == null) {
        return state;
      }

      return {
        ...state,
        [module]: state[module] - 1,
      };
    },
  },
});

const { actions } = moduleCounters;
const selectors = {
  getModuleState: (state, module: string) => state[NAME][module],
};

export { actions, selectors, modules };
export default moduleCounters;
