import React from 'react';
import RenderDatePicker from 'requestForms/components/RenderDatePicker';
import DatePicker from 'requestForms/components/FieldDatePicker';
import cx from 'classnames';
import css from '../BaseForm/style.scss';

const FieldDateRange = ({
  className,
  fieldClassName,
  startName,
  endName,
  size = 'l',
  popupPosition,
  label,
  hasIcon = true,
}) => {
  let firstPopupPos = popupPosition;
  let secondPopupPos = popupPosition;
  if (Array.isArray(popupPosition)) {
    [firstPopupPos, secondPopupPos] = popupPosition;
  }

  return (
    <div className={cx(className, css.FieldDateRange)}>
      {label && <div className={css.FieldDateRange__label}>{label}</div>}
      <DatePicker
        label="с"
        name={startName}
        className={fieldClassName}
        component={RenderDatePicker}
        hasIcon={hasIcon}
        size={size}
        popupPosition={firstPopupPos}
      />
      &mdash;
      <DatePicker
        label="по"
        name={endName}
        className={fieldClassName}
        component={RenderDatePicker}
        hasIcon={hasIcon}
        size={size}
        popupPosition={secondPopupPos}
      />
    </div>
  );
};

export default FieldDateRange;
