import React from 'react';
import PropTypes from 'prop-types';
import Button from '@crm/components/dist/lego2/Button';
import Popup from '@crm/components/dist/lego2/Popup';
import FilterTreeView from 'containers/TreeSelect/FilterTreeView';
import connectorTreeView from 'containers/TreeSelect/connectorTreeView';
import get from 'lodash/get';
import css from './FieldTreeSelect.module.css';

const spanStyles = {
  minWidth: 0,
  flex: 1,
  overflow: 'hidden',
  textOverflow: 'ellipsis',
};

const TreeContainer = connectorTreeView({
  mode: connectorTreeView.MODE.HIERARCHY_CHECK,
  toggleButtons: true,
  clearButton: true,
})(FilterTreeView);

const DIRECTIONS = ['bottom-left', 'bottom-right'];

const style = { width: '100%', minWidth: 0, flexGrow: 1, flexBasis: 0 };

export default class FieldTreeSelect extends React.Component {
  constructor(props) {
    super(props);

    this.state = { visible: false };
    this.button = React.createRef();
  }

  handleOnChange = (...args) => {
    this.props.input.onChange(...args);
    if (this.props.mode === 'radio') {
      this.hide();
    }
  };

  show = () => {
    this.setState({ visible: true });
  };

  hide = () => {
    this.setState({ visible: false });
  };

  toggle = () => {
    if (this.state.visible) {
      this.hide();
    } else {
      this.show();
    }
  };

  render() {
    const {
      displayKeySlug,
      mode,
      name,
      endpoint,
      backendDataType,
      getSlugId,
      canItemClick,
      input: { value },
      size,
      labelPrefix,
      labelWidth,
      defaultValueText,
    } = this.props;

    /*
      с бека приходит структура:
      {
        id: 1,
        name: 'name'
      }

      пока костыльно поправлю чтобы бралось name если данные с бека.
    */
    const selectedFolderName = get(value, `selectedItem.${displayKeySlug}`) || get(value, 'name');
    const count = get(value, 'selectedArray.length');

    return (
      <React.Fragment>
        <Button
          style={style}
          size={size}
          type="button"
          width="max"
          onClick={this.toggle}
          innerRef={this.button}
        >
          <div className={css.FieldTreeSelect__buttonWrap}>
            {labelPrefix && (
              <span style={{ color: 'grey', width: labelWidth, textAlign: 'left' }}>
                {labelPrefix}
              </span>
            )}
            <span style={{ ...spanStyles, textAlign: 'right' }}>
              {selectedFolderName || (count && `Выбрано ${count}`) || defaultValueText}
            </span>
          </div>
        </Button>
        <Popup
          autoZIndex
          onOutsideClick={this.hide}
          target="anchor"
          anchor={this.button}
          directions={DIRECTIONS}
          visible={this.state.visible}
          padding="xs"
        >
          <TreeContainer
            onChange={this.handleOnChange}
            mode={mode}
            name={name}
            endpoint={endpoint}
            backendDataType={backendDataType}
            getSlugId={getSlugId}
            canItemClick={canItemClick}
            selected={value}
            destroyOnUnmount
            nestedValue
            autoFocus
          />
        </Popup>
      </React.Fragment>
    );
  }
}

FieldTreeSelect.propTypes = {
  input: PropTypes.instanceOf(Object).isRequired,
  displayKeySlug: PropTypes.string,
  mode: PropTypes.string,
  name: PropTypes.string,
  size: PropTypes.string,
  backendDataType: PropTypes.string,
  endpoint: PropTypes.string,
  labelWidth: PropTypes.number,
  labelPrefix: PropTypes.string,
  defaultValueText: PropTypes.string,
  canItemClick: PropTypes.func,
  getSlugId: PropTypes.func,
};

FieldTreeSelect.defaultProps = {
  size: 'l',
  name: 'FOLDERS',
  endpoint: '/view/mail/folder/list',
  defaultValueText: '',
  displayKeySlug: 'name',
  labelPrefix: null,
  labelWidth: undefined,
  mode: undefined,
  backendDataType: undefined,
  getSlugId: undefined,
  canItemClick: undefined,
};
