import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import css from '../BaseForm/style.scss';
import Required from './Required';

const FormWrap = props => {
  const { view, hint, children, ...passPropsThrough } = props;

  return (
    <form
      className={cx(css.form, view === 'compact' ? 'isCompact' : 'isRegular')}
      {...passPropsThrough}
    >
      {hint === true && <Required />}
      {children}
    </form>
  );
};

FormWrap.propTypes = {
  view: PropTypes.string,
  hint: PropTypes.bool,
  children: PropTypes.node,
};

FormWrap.defaultProps = {
  view: undefined,
  hint: false,
  children: undefined,
};

export default FormWrap;
