import React from 'react';
import Textinput from '@crm/components/dist/lego2/Textinput';
import LazilyLoad, { importLazy } from 'utils/LazilyLoad';
import cx from 'classnames';
import { dateParse } from '../utils/dateConvertor';
import withError from './withError';

const importMomentLocale = () => importLazy(import('moment/locale/ru'));
const importDatePicket = () => importLazy(import('jk-react-date-picker'));

class RenderDatePicker extends React.Component {
  handleChange = (value) => {
    const {
      input: { onChange },
      withTime,
    } = this.props;

    if (value && value !== '' && value !== 'Invalid date') {
      onChange(dateParse(value, withTime));
    } else {
      onChange('');
    }
  };

  renderInput = (props) => {
    const {
      label,
      meta: { touched, error },
      size,
      id,
      hasClear,
      view,
      autoFocus,
      ...custom
    } = this.props;

    return (
      <Textinput
        {...props}
        {...custom}
        placeholder={label}
        id={id}
        state={touched && error ? 'error' : undefined}
        hint={touched && error}
        size={size}
        hasClear={!!hasClear}
        autoFocus={autoFocus}
      />
    );
  };

  render() {
    const { input, className, formatDate, pickerProps, popupPosition, view, hasIcon } = this.props;
    const { value } = input;

    const inputProps = {};

    if (view === 'inline') {
      inputProps.expanded = true;
    }

    return (
      <span
        className={cx(className, { 'react-date-field_right': popupPosition === 'right' })}
        style={{ position: 'relative', display: 'inline-flex', flexWrap: 'wrap' }}
      >
        <LazilyLoad modules={{ locale: importMomentLocale, datePickerModule: importDatePicket }}>
          {({ datePickerModule }) => {
            const { DateField, Calendar } = datePickerModule;

            return (
              <DateField
                {...inputProps}
                {...pickerProps}
                renderCalendarIcon={hasIcon ? undefined : () => null}
                disabled={!!this.props.disabled}
                locale="ru"
                dateFormat={formatDate || 'DD.MM.YYYY'}
                theme={view === 'default' ? 'islands' : view}
                renderInput={this.renderInput}
                forceValidDate
                updateOnDateClick
                expandOnFocus
                collapseOnDateClick
                defaultValue={value}
                onChange={this.handleChange}
              >
                <Calendar
                  forceValidDate
                  highlightWeekends
                  highlightToday
                  weekNumbers={false}
                  weekStartDay={1}
                  footer={false}
                />
              </DateField>
            );
          }}
        </LazilyLoad>
      </span>
    );
  }
}

RenderDatePicker.defaultProps = {
  hasClear: true,
  view: 'default',
  size: 'm',
  popupPosition: undefined,
  autoFocus: false,
};

export default withError(RenderDatePicker);
