/**
 * добавляет компонентам тултип с ошибкой из redux-form props
 * */

import React from 'react';
import Tooltip from '@crm/components/dist/lego2/Tooltip';
import cx from 'classnames';
import getDisplayName from 'utils/getDisplayName';
import css from './withError.scss';

const withError = (WrappedComponent) => {
  class WithError extends React.Component {
    render() {
      const {
        className,
        classNameError,
        componentClassName,
        displayError,
        errorPlacement,
        errorOffset,
        ...other
      } = this.props;

      const {
        meta: { touched, pristine, error },
      } = other;

      return (
        <span
          className={cx(className, css.b)}
          ref={(node) => {
            this.container = node;
          }}
        >
          <WrappedComponent {...other} className={componentClassName} />
          <Tooltip
            className={classNameError}
            visible={Boolean((touched || (displayError && !pristine)) && error)}
            directions={errorPlacement}
            boundary={{ current: document.body }}
            anchor={{ current: this.container }}
            hasTail
            view="default"
            size="s"
            state="alert"
          >
            {error}
          </Tooltip>
        </span>
      );
    }
  }
  WithError.defaultProps = {
    errorPlacement: ['right-top'],
  };
  WithError.displayName = `WithError(${getDisplayName(WrappedComponent)})`;
  return WithError;
};

export default withError;
