/**
 * конвертирует props из redux-form в react-islands props
 * */

import React from 'react';
import getDisplayName from 'utils/getDisplayName';
import yaFocusHandle from '../utils/yaFocusHandle';

const withReduxFormProps = config => WrappedComponent => {
  class WithReduxFormProps extends React.Component {
    render() {
      const {
        input,
        label,
        meta: { active },
        className,
        size,
        refComponent,
        ...custom
      } = this.props;

      return (
        <WrappedComponent
          placeholder={label}
          className={className}
          size={size}
          onFocusChange={yaFocusHandle}
          focused={active}
          ref={refComponent}
          {...input}
          {...custom}
          {...this.props.extraProps(this.props)}
        />
      );
    }
  }

  WithReduxFormProps.defaultProps = {
    size: 'l',
    hasClear: true,
    extraProps: () => {},
    ...config,
  };

  WithReduxFormProps.displayName = `WithReduxFormProps(${getDisplayName(WrappedComponent)})`;
  return WithReduxFormProps;
};

export default withReduxFormProps;
