import forOwn from 'lodash/forOwn';
import { dateFormat } from '../utils/dateConvertor';

export const mergeMeta = (data, meta) => {
    if (!data) {
        return;
    }

    if (!meta) {
        return data;
    }

    let newData = {};

    const merge = (node, root) => {
        forOwn(node, (v, k) => {
            const fieldMeta = meta.fields[k];

            if (!meta.fields[k]) {
                return;
            }

            if (fieldMeta.type === 'array') {
                let arrData = {
                  type: fieldMeta.type,
                  caption: fieldMeta.caption,
                };

                const arrDataArray = v.map(item => {
                    if (typeof item === 'object') {
                        let newNode = {};
                        merge(item, newNode);
                        return newNode;
                    } else if (fieldMeta['itemKey']) {
                        const label = fieldMeta['itemKey'];
                        const val = getFieldObj(item, label);
                        return val ? {[label]: val} : null;
                    } else {
                        const val = getFieldObj(v, k);
                        return val ? val : null;
                    }
                });

                arrDataArray.filter(value => !!value);

                if (arrDataArray) {
                    arrData.array = arrDataArray;
                    root[k] = arrData;
                }
            } else if (fieldMeta.type === 'plainArray') {
                const arrData = {
                    type: fieldMeta.type,
                    caption: fieldMeta.caption,
                    plainArrayType: 'enum',
                    value: v,
                };

                const arrDataText = v.map(item => {
                    const val = fieldMeta.map[item];
                    return val ? val : null;
                });

                arrDataText.filter(value => !!value);

                if (arrDataText) {
                    arrData.plainArrayText = arrDataText;
                    root[k] = arrData;
                }
            } else {
                const val = getFieldObj(v, k);
                if (val) root[k] = val;
            }
        })
    }

    const getFieldObj = (v, k) => {
        const fieldMeta = meta.fields[k];
        let field = {
            type: fieldMeta.type,
            caption: fieldMeta.caption,
            text: v,
            value: v,
        };

        if (fieldMeta.type === 'enum') {
            if (fieldMeta.fType === 'select') {
                field.value = v && v.length ? v[0] : v;
                field.text = fieldMeta.map[field.value];
            } else if (fieldMeta.fType === 'checkboxGroup') {
                field.text = v && v.length ? v.map(i => fieldMeta.map[i]).join(', ') : '';
            } else {
                field.text = fieldMeta.map[v];
            }
        }

      if (fieldMeta.type === 'bool') {
        field.text = field.value ? 'Да' : 'Нет';
      }

      if (fieldMeta.fType === 'datepicker') {
        field.text = dateFormat(field.value);
      }

      return field.value === undefined || field.value === '' ? null : field;
    }

    merge(data, newData);

    return newData;
};

export const parse = (data, meta) => {
    if (!data) {
        return;
    }

    let newData = {};
    const _parse = (node, root) => {
        forOwn(node, (v, k) => {
            if (!meta.fields[k]) return;

            if (v.array) {
                root[k] = v.array.map(item => {
                    let itemNode = {};
                    if (meta.fields[k]['itemKey']) {
                        return item[meta.fields[k]['itemKey']].value;
                    } else {
                        _parse(item, itemNode)
                    }
                    return itemNode;
                });
            } else {
                if (meta.fields[k].fType === 'select') {
                    root[k] = [v.value];
                } else {
                    root[k] = v.value;
                }
            }

        })
    };

    _parse(data, newData);
    return newData;
};