/* global isNan*/
import toLocalISOString from 'utils/date/toLocalISOString';


const addLeadZero = value => (value < 10 ? `0${value}` : value);

/**
 * 2017-02-14T00:00:00.000+03:00 => 14.02.2017
 **/
export const dateFormat = (date, withTime) => {
  const mDate = new Date(date);
  if (!Number.isNaN(mDate.getTime())) {
    let time = '';

    if (withTime) {
      time = ` ${addLeadZero(mDate.getHours())}:${addLeadZero(mDate.getMinutes())}`;
    }

    return `${addLeadZero(mDate.getDate())}.${addLeadZero(mDate.getMonth() + 1)}.${mDate.getFullYear()}${time}`;
  }
  return date;
};

/**
 * 14.02.2017 => 2017-02-14T00:00:00.000+03:00
 **/
export const dateParse = (date, withTime) => {
  if (typeof date === 'string') {
    let strParse;
    let dateObj;

    if (withTime) {
      strParse = date.match(/(\d{2}).(\d{2}).(\d{4}) (\d{2}):(\d{2})/);
    } else {
      strParse = date.match(/(\d{2}).(\d{2}).(\d{4})/);
    }

    if (strParse && strParse[0]) {
      if (withTime) {
        dateObj = new Date(
          parseInt(strParse[3], 10),
          parseInt(strParse[2], 10) - 1,
          parseInt(strParse[1], 10),
          parseInt(strParse[4], 10),
          parseInt(strParse[5], 10),
        );
      } else {
        dateObj = new Date(
          parseInt(strParse[3], 10),
          parseInt(strParse[2], 10) - 1,
          parseInt(strParse[1], 10),
        );
      }

      return toLocalISOString(dateObj);
    }
  }

  return date;
};
