import { makeAutoObservable, runInAction, reaction, IReactionDisposer } from 'mobx';
import { IssueIdDTO } from 'types/IssueIdDTO';
import { webphoneService } from 'services/WebphoneService';

export class ActiveCallIssueService {
  private _issue?: IssueIdDTO;
  private dispose: IReactionDisposer;

  constructor() {
    makeAutoObservable(this);

    this.registerAutoCallEndClean();
  }

  destroy() {
    this.dispose();
  }

  set issue(issue: IssueIdDTO | undefined) {
    if (!webphoneService.hasActiveCall) {
      return;
    }

    this._issue = issue;
  }

  get issue() {
    return this._issue;
  }

  clear() {
    this._issue = undefined;
  }

  private registerAutoCallEndClean() {
    this.dispose = reaction(
      () => webphoneService.hasActiveCall,
      (hasActiveCall) => {
        if (!hasActiveCall) {
          runInAction(() => {
            this._issue = undefined;
          });
        }
      },
    );
  }
}
