import { jsonApiCall, get } from 'api/common';
import { MutationData } from '../PersonalCallService/PersonalCallService.types';

export const loadCallData = (activityId: number) =>
  get({
    url: `/activities/${activityId}`,
  });

export const validateData = (activityId: number) =>
  jsonApiCall({
    url: `/activities/${activityId}/validate`,
    showBackendErrorForUser: false,
  });

export const mutateActivity = (data: MutationData & { id: number }) =>
  jsonApiCall({
    url: `/activities/mutation`,
    global: false,
    data: { data },
  });

export const getLastNotDoneActivity = () =>
  get({
    url: `/activities/active`,
    global: false,
    showBackendErrorForUser: false,
  });
