import { useContext, useEffect } from 'react';
import { useHistory } from 'react-router-dom';
import { XivaContext } from 'modules/xiva';
import { CallIssueRedirectByXiva } from './CallIssueRedirectByXiva';

export const CallIssueRedirectByXivaReactConnector = () => {
  const xiva = useContext(XivaContext);
  const history = useHistory();

  useEffect(() => {
    const callIssueRedirectByXiva = new CallIssueRedirectByXiva(history, xiva);

    return () => {
      callIssueRedirectByXiva.destroy();
    };
  }, []);

  return null;
};
