import { jsonApiCall } from 'api/common';
import Bluebird from 'bluebird';
import { notifications } from 'services/Notifications';
import { config } from 'services/Config';
import { terminalIdService } from 'services/TerminalIdService';
import { errors } from './CallService.config';
import { CallOptions } from './CallService.types';

export class CallService {
  private isCreateCallInProgress = false;

  call(options: CallOptions) {
    if (this.isCreateCallInProgress) {
      notifications.warning(errors.creatingCall);
      return Bluebird.resolve(false);
    }

    if (!config.value.useExternalPhone && !terminalIdService.value) {
      notifications.warning(errors.webphoneNotReady);
      return Bluebird.resolve(false);
    }

    if (!config.value.useExternalPhone) {
      options = { ...options };
      options.terminalId = terminalIdService.value;
    }

    this.isCreateCallInProgress = true;

    return jsonApiCall<CallOptions, unknown>({ url: '/yacalls/createCall', data: options }).finally(
      () => {
        this.isCreateCallInProgress = false;
      },
    );
  }
}
