import { Config as ConfigDTO } from 'types/Config';
import merge from 'lodash/merge';
import { defaultConfig } from './defaultConfig';

export class Config {
  private _value: ConfigDTO = defaultConfig;

  constructor(value: ConfigDTO) {
    this.value = value;
  }

  set value(value: ConfigDTO) {
    const formattedValue = value;

    // TODO: delete after backend CRM-12721
    if (!formattedValue.config) {
      formattedValue.config = defaultConfig.config;
    }

    merge(this._value, formattedValue);
  }

  get value() {
    return this._value;
  }
}
