import { Config, ModuleConfig } from 'types/Config';

const issueModuleConfig: ModuleConfig = {
  create: {
    modal: 0,
    inline: 3,
  },
  search: {
    category: 0,
    scope: 3,
    state: 3,
    resolution: 3,
    type: 3,
    author: 3,
    owner: 3,
    onlyActualOwner: 0,
    queue: 0,
    communication: 0,
    clientIdLogin: 3,
    inn: 0,
    contractNum: 0,
    createDate: 3,
    deadlineDate: 3,
    tag: 3,
    currentAmount: 0,
    opportunitySource: 0,
    plannedCompletionDate: 0,
  },
  takeNext: 0,
  filters: 3,
  sortItems: [
    {
      value: '5',
      content: 'Дата создания ▲',
    },
    {
      value: '6',
      content: 'Дата создания ▼',
    },
    {
      value: '7',
      content: 'Дата дедлайна ▲',
    },
    {
      value: '8',
      content: 'Дата дедлайна ▼',
    },
    {
      value: '9',
      content: 'Дата обновления ▲',
    },
    {
      value: '10',
      content: 'Дата обновления ▼',
    },
  ],
};

const ticketModuleConfig: ModuleConfig = {
  create: {
    modal: 3,
    inline: 0,
  },
  search: {
    category: 3,
    scope: 3,
    state: 3,
    resolution: 3,
    type: 0,
    author: 3,
    owner: 3,
    onlyActualOwner: 3,
    queue: 3,
    communication: 3,
    clientIdLogin: 3,
    inn: 3,
    contractNum: 3,
    createDate: 3,
    deadlineDate: 3,
    tag: 3,
    currentAmount: 0,
    opportunitySource: 0,
    plannedCompletionDate: 0,
  },
  takeNext: 3,
  filters: 0,
  sortItems: [
    {
      value: '1',
      content: 'Дата последнего события ▲',
    },
    {
      value: '2',
      content: 'Дата последнего события ▼',
    },
    {
      value: '5',
      content: 'Дата создания ▲',
    },
    {
      value: '6',
      content: 'Дата создания ▼',
    },
    {
      value: '3',
      content: 'Приоритет ▼, дата последнего события ▲',
    },
    {
      value: '4',
      content: 'Приоритет ▼, крайний срок начала работы ▲, дата последнего события ▲',
    },
  ],
};

const opportunitiesModuleConfig: ModuleConfig = {
  create: {
    modal: 3,
    inline: 0,
  },
  search: {
    category: 0,
    scope: 3,
    state: 3,
    resolution: 3,
    type: 0,
    author: 3,
    owner: 3,
    onlyActualOwner: 0,
    queue: 0,
    communication: 3,
    clientIdLogin: 3,
    inn: 0,
    contractNum: 0,
    createDate: 3,
    deadlineDate: 3,
    tag: 3,
    currentAmount: 3,
    opportunitySource: 3,
    plannedCompletionDate: 3,
  },
  takeNext: 0,
  filters: 0,
  sortItems: [
    {
      value: '5',
      content: 'Дата создания ▲',
    },
    {
      value: '6',
      content: 'Дата создания ▼',
    },
  ],
};

export const defaultConfig: Config = {
  app: { backend: '', frontend: '' },
  backendAdminPanelHost: window.CRM_SPACE_API_HOST ?? '',
  availableDelegations: [],
  config: {
    features: { logMetrika: true },
    intervals: {
      default: 60000,
      issuesRefresh: 60000,
      userStatus: 15000,
      viewMailListRefresh: 60000,
      viewNotificationList: 60000,
      viewUserState: 60000,
    },
    configMap: {
      Issue: issueModuleConfig,
      Ticket: ticketModuleConfig,
      Opportunity: opportunitiesModuleConfig,
    },
  },
  features: {
    autoAssignIssues: false,
    comDepMoney: false,
    currency: false,
    dtsMailRouting: false,
    newDesignObject: {
      filters: false,
    },
    newDesignFilters: false,
    newDesignAttributes: false,
    useTicketStructuredFilters: false,
    issueTimelineV2: false,
    issueHeaderV2: false,
    useYaCalls: false,
    useYaCallsLB: false,
    yaCallsLogsCanForcePause: false,
    useUserStatuses: false,
    massMailImprovements: false,
    personalUnits: false,
    enableInternalChats: false,
    categoryTipsExperiment: false,
    categoryTipsButtonExperiment: false,
    activityTab: false,
    newFrontendLogs: false,
    newDesignLift: false,
    newRealtimeLimit: false,
    newActivitiesDesign: false,
    newMessageControls: false,
    newEditingFiles: false,
    useYfm: false,
  },
  hostName: '',
  isAutoreply: false,
  modules: {
    account: false,
    accountList: false,
    adminAccess: {
      any: false,
      categories: false,
      statface: false,
      system: false,
      templates: false,
      users: false,
    },
    any: false,
    billing: false,
    chat: false,
    history: false,
    issue: false,
    mail: false,
    lift: false,
    massmail: false,
    mcsMail: false,
    mcsReview: false,
    notifications: false,
    personalDashboard: false,
    reports: false,
    settingsAccess: {
      accountTags: false,
      any: false,
      autoreplies: false,
      delegations: false,
      folders: false,
      issue: false,
      mailRules: false,
      mailing: false,
      notifications: false,
      other: false,
      queues: false,
      signatures: false,
      supports: false,
      tags: false,
      telephony: false,
      templates: false,
      upsaleRule: false,
    },
    telephony: false,
    ticket: false,
  },
  useExternalPhone: false,
  showPhoneNumber: false,
  teamMembers: [],
  testMode: false,
  useXiva: true,
  infraPresetId: '',
  user: {
    id: -1,
    isAdmin: false,
    isGrouplead: false,
    isSupport: false,
    isTeamlead: false,
    login: 'null',
    mainRole: '',
    name: '',
    position: '',
  },
  version: '',
};
