/**
 * Something about models
 * 1. Each model instance is singleton
 * 2. methods name content prefix "p" - is mean parent
 */
import { DatabaseCrm } from '../types';

const instances = {};

export default class Model {
  public userId: number;

  public table: string;

  public type: string;

  public db: Promise<DatabaseCrm>;

  public constructor(db, userId) {
    if (instances[this.constructor.name]) {
      return instances[this.constructor.name];
    }
    this.db = db;
    if (userId) {
      this.userId = userId;
    } else {
      this.throwError(`${this.constructor.name} create - User ID is cannot be undefined`);
    }
    instances[this.constructor.name] = this;
  }

  public pGetAll = async (index, indexKeys, reducer) => {
    try {
      const db = await this.db;
      const tx = db.transaction(this.table);
      const store = tx.objectStore(this.table);
      const currentIndex = store.index(index);
      const value = await currentIndex.getAll(indexKeys);
      await tx.done;
      return value.reduce(reducer, {});
    } catch (error) {
      this.throwError(error);
      return {};
    }
  };

  public pUpdate = async (payload, index: string, indexKeys) => {
    try {
      const db = await this.db;
      const tx = db.transaction(this.table, 'readwrite');
      const store = tx.objectStore(this.table);
      const currentIndex = store.index(index);

      const value = await currentIndex.get(indexKeys);

      await store.put({ type: this.type, ...value, ...payload });
      await tx.done;
    } catch (error) {
      this.throwError(error);
    }
  };

  public throwError = (error) => {
    throw new Error(error);
  };
}
