import DBProvider from '../index';
import { ModelType, ModelInstance } from './types';
import { arrayModels, stateModels } from './index';

const mapModels: Map<ModelType, ModelInstance> = arrayModels.reduce((acc, model) => {
  acc.set(model, model);
  return acc;
}, new Map());

const mapStateModels: Map<ModelType, ModelInstance> = stateModels.reduce((acc, model) => {
  acc.set(model, model);
  return acc;
}, new Map());

const modelsCache = () => {
  const cache: Map<ModelType, ModelType> = new Map();
  return async (model: ModelType) => {
    if (cache.has(model)) {
      return cache.get(model);
    }
    await DBProvider.initialized;
    const { db, stateDB, userId } = DBProvider;
    if (mapModels.has(model)) {
      const currentModel = mapModels.get(model) as ModelInstance;
      cache.set(model, new currentModel(db, userId));
      return cache.get(model);
    } else if (mapStateModels.has(model)) {
      const currentModel = mapStateModels.get(model) as ModelInstance;
      cache.set(model, new currentModel(stateDB, userId));
      return cache.get(model);
    }
    throw Error(`Model '${model.table}' is not found in mapModels`);
  };
};

export const getBindInstance = modelsCache();
