import { PanelPayload } from './types';
import Model from '../Model';
import { ConfigType } from '../types';

const reducer = (acc, value) => {
  acc[value.panelId] = {
    type: value.type,
    pin: value.pin,
    panelId: value.tabId,
  };

  return acc;
};

export default class PanelModel extends Model {
  public static config: ConfigType = {
    table: 'panel',
    primaryKey: { keyPath: 'id', autoIncrement: true },
    indexes: [
      { name: 'by-user', keyPath: 'userId', options: {} },
      { name: 'by-user-and-panel', keyPath: ['userId', 'panelId'], options: { unique: true } },
      { name: 'by-user-and-type', keyPath: ['userId', 'type'], options: {} },
    ],
  };

  public type: string = 'ui-settings';

  public table: string;

  public constructor(db, userId) {
    super(db, userId);
    this.table = PanelModel.config.table;
  }

  public getAll = async () => {
    const { userId } = this;
    const index = 'by-user-and-type';
    const indexKeys = [userId, this.type];
    return this.pGetAll(index, indexKeys, reducer);
  };

  public update = async (payload: PanelPayload): Promise<void> => {
    const { panelId } = payload;
    const { userId } = this;
    const indexKeys = [userId, panelId];
    const index = 'by-user-and-panel';
    this.pUpdate({ ...payload, panelId, userId }, index, indexKeys);
  };
}
