export type PanelId = string | number;

export interface Panel {
  id?: number;
  pin?: boolean;
  tabId?: number | string;
  panelId: PanelId;
  userId: number;
}

export interface PanelPayload {
  pin?: boolean;
  tabId?: number | string;
  panelId: PanelId;
}

export interface DBPanelScheme {
  value: Panel;
  key: number;
  indexes: {
    'by-user': number;
    'by-user-and-panel': [number, PanelId];
  };
}
