import Model from '../Model';
import { ConfigType } from '../types';
import { ResizePayload } from './types';

const reducer = (acc, item) => {
  acc[item.panelId] = {
    type: item.type,
    size: item.size,
  };

  return acc;
};

export default class ResizeModel extends Model {
  public static config: ConfigType = {
    table: 'resize',
    primaryKey: { keyPath: 'id', autoIncrement: true },
    indexes: [
      { name: 'by-user', keyPath: 'userId', options: {} },
      { name: 'by-user-and-panel', keyPath: ['userId', 'panelId'], options: { unique: true } },
      { name: 'by-user-and-type', keyPath: ['userId', 'type'], options: {} },
    ],
  };

  public type: string = 'ui-settings';

  public table: string;

  public constructor(db, userId) {
    super(db, userId);
    this.table = ResizeModel.config.table;
  }

  public getAll = async () => {
    const { userId } = this;
    const index = 'by-user-and-type';
    const indexKeys = [userId, this.type];
    return this.pGetAll(index, indexKeys, reducer);
  };

  public update = async (payload: ResizePayload): Promise<void> => {
    const { panelId } = payload;
    const { userId } = this;
    const indexKeys = [userId, panelId];
    const index = 'by-user-and-panel';
    this.pUpdate({ ...payload, panelId, userId }, index, indexKeys);
  };
}
