import { PanelId } from '../Panel/types';

export interface Resize {
  id?: number;
  size?: {
    width?: number;
  };
  panelId: PanelId;
  userId: number;
}

export interface ResizePayload {
  width?: number;
  panelId: PanelId;
  userId: number;
}

export interface DBResizeScheme {
  value: Resize;
  key: number;
  indexes: {
    'by-user': number;
    'by-user-and-panel': [number, PanelId];
  };
}
