import { StatePayload } from './types';
import Model from '../Model';
import { ConfigType } from '../types';

const reducer = (acc, value) => value.data;

export default class StateModel extends Model {
  public static config: ConfigType = {
    table: 'state',
    primaryKey: { keyPath: 'userId' },
    indexes: [{ name: 'by-user', keyPath: 'userId', options: { unique: true } }],
  };

  public type: string = 'redux-state';

  public table: string;

  public constructor(db, userId) {
    super(db, userId);
    this.table = StateModel.config.table;
  }

  public setUserId = (userId: number) => {
    this.userId = userId;
  };

  public getAll = async () => {
    const { userId } = this;
    const index = 'by-user';
    const indexKeys = userId;
    return this.pGetAll(index, indexKeys, reducer);
  };

  public update = async (payload: StatePayload): Promise<void> => {
    const { userId } = this;
    const indexKeys = [userId];
    const index = 'by-user';
    return this.pUpdate({ data: payload, userId }, index, indexKeys);
  };
}
