import { DBSchemeCrm } from '../types';
import PanelModel from './Panel';
import ResizeModel from './Resize';
import StateModel from './State';

interface IndexType {
  keyPath: string | string[];
  name: string;
  options?: IDBIndexParameters;
}

export interface ConfigType {
  table: keyof DBSchemeCrm;
  primaryKey: IDBObjectStoreParameters;
  indexes: IndexType[];
}

export type ModelType = PanelModel | ResizeModel | StateModel;

export type ModelInstance = typeof ResizeModel | typeof PanelModel | typeof StateModel;
