import { openDB } from 'idb';
import { DBSchemeCrm } from './types';
import { arrayModels, ModelInstance } from './Models';

export default async (
  name: string = 'my-db',
  models: ModelInstance[] = arrayModels,
  version: number = 1,
) => {
  const dbInstance = await openDB<DBSchemeCrm>(name, version, {
    upgrade(db) {
      models.forEach((model) => {
        if (!db.objectStoreNames.contains(model.config.table)) {
          const modelStore = db.createObjectStore(model.config.table, model.config.primaryKey);
          model.config.indexes.forEach((index) => {
            modelStore.createIndex(index.name, index.keyPath, index.options);
          });
        }
      });
    },
    blocking() {
      dbInstance.close();
    },
  });

  return dbInstance;
};
