import { DatabaseCrm } from './types';
import { arrayModels, stateModels, ModelType, ModelInstance } from './Models';
import createDB from './createDB';

export * from './types';

let initCb;
const resolvePromise = (resolve) => () => {
  resolve('initialized');
};

const getModelsInstancesArray = (db, userId, models: ModelInstance[] = arrayModels) =>
  models.map((Model) => new Model(db, userId));

class DBProvider {
  public db: DatabaseCrm | null = null;
  public stateDB: DatabaseCrm | null = null;

  public initialized = new Promise((resolve) => {
    initCb = resolvePromise(resolve);
  });

  public userId: number;

  public models: ModelType[];

  public init = async (userId) => {
    this.db = await createDB();
    this.stateDB = await createDB('state-db', stateModels);
    this.userId = userId;
    this.models = getModelsInstancesArray(this.db, this.userId);
    this.models = this.models.concat(
      getModelsInstancesArray(this.stateDB, this.userId, stateModels),
    );
    initCb();
  };

  public getState = async () => {
    const array = this.models.map((model) => model.getAll());
    const result = await Promise.all(array);
    return result.reduce((acc, value, index) => {
      acc[this.models[index].table] = value;
      return acc;
    }, {});
  };
}

export default new DBProvider();
