## DBProvider - провайдер для работы с внешним хранилищем.

### WorkFlow
 #### Инициализация
1. Выполняем инициализацию ``DBProvider.init(userId: number)``. В этот момент создается БД на основании настроек моделей подключенных к провайдеру в момент инициализации.
2. После инициализации мы забираем state из БД методом ``DBProvider.getState()`` и пишем его в State приложения

 #### Работа с моделями
- Создание модели
    * Все модели лежат в папке `models` и наследуются от класса `Model`.
    * Содержат поле `type` для разделения типов хранимых данных
    * Содержат в себе конфигурацию для первичного построения струткуры БД, методы для работы с данными (пока 2 - чтение и обновление)
    * Являются `singleton`  поскольку инстансы никак не модифицируются и я не увидел смысла плодить много разных объектов одного класса.
- Добавление в провайдер
    * Подключить модель к провайдеру можно в файле `Models/index.ts` добавив в массив `arrayModels` 
- Использование    
    * Получение инстанса модели возможно через метод `getModelInstance(ModelName: string)`
    * Модель является промисом и будет зарезолвлена после инициализации провайдера.

  
