import { IDBPDatabase } from 'idb';
import { DBPanelScheme } from './Models/Panel/types';
import { DBResizeScheme } from './Models/Resize/types';
import { DBStateScheme } from './Models/State/types';

export interface DBSchemeCrm {
  resize: DBResizeScheme;
  panel: DBPanelScheme;
  state: DBStateScheme;
}

export type DatabaseCrm = IDBPDatabase<DBSchemeCrm>;

export type Action<P = object, T = unknown> = (payload: P) => Promise<T>;

export type ActionWrap<P = object, T = unknown> = (db: DatabaseCrm, userId: number) => Action<P, T>;

export type ActionMapper<T extends { [key: string]: ActionWrap }> = {
  [P in keyof T]: ReturnType<T[P]>;
};

export type GetState<P = unknown> = (db: DatabaseCrm, userId: number) => P;
