import { Subject } from 'rxjs';
import React, { createContext, FC, useContext, useState } from 'react';
import createContextHOC from 'utils/createContextHOC';
import { FactorFile } from 'modules/upsale';

export interface FactorData {
  factorId: number;
  templateText: string;
  files: FactorFile[];
}

export interface FactorsChangeEvent {
  type: 'add' | 'remove' | 'change';
  payload: FactorData;
}

export type FactorContextProps = Subject<FactorsChangeEvent | undefined>;

export interface InjectedContextProps {
  factorStream: FactorContextProps;
}

export const FactorContext = createContext((null as unknown) as FactorContextProps);
export const Consumer = FactorContext.Consumer;
export const Provider = FactorContext.Provider;

export const FactorStreamProvider: FC = ({ children }) => {
  const [factorStream] = useState(new Subject<FactorsChangeEvent | undefined>());

  return <Provider value={factorStream}>{children}</Provider>;
};

export const useFactorStream = () => useContext(FactorContext);

export const withFactorStreamProps = createContextHOC<FactorContextProps, InjectedContextProps>({
  Context: FactorContext,
  propName: 'factorStream',
});
