import { History, UnregisterCallback } from 'history';

export class ForceChangeLocationFlag {
  private _next = false;
  private _current = false;

  private unregisterCallback: UnregisterCallback;

  constructor(private history: History) {
    this.unregisterCallback = history.listen(() => {
      this._current = this._next;
      this._next = false;
    });
  }

  destroy() {
    this.unregisterCallback();
  }

  setFlagForNextUpdate(flag: boolean) {
    this._next = flag;
  }

  get current() {
    return this._current;
  }

  get next() {
    return this._next;
  }
}
