import { rest } from 'msw';
import { PageableDTO } from 'types/pagination/PageableDTO';
import { PageableItemDTO } from 'types/pagination/PageableItemDTO';
import { WithGridMeta, SortOrder } from '../types/GridMeta';

const generateData = (
  fromId: number,
  length: number,
): PageableDTO<PageableItemDTO> & WithGridMeta => {
  return {
    meta: {
      fieldsVisibility: ['1', '2'],
      sort: [{ id: '1', order: SortOrder.Asc }],
      fields: [
        {
          id: '1',
          title: 'Id',
          sortable: true,
          isPinned: false,
          type: 'Text',
          access: 3,
        },
        {
          id: '2',
          title: 'Name',
          sortable: true,
          isPinned: false,
          type: 'Text',
          access: 3,
        },
      ],
    },
    data: new Array(length)
      .fill(1)
      .map((_, index) => ({ id: String(index + fromId), name: `name_${String(index + fromId)}` })),
    pagination: {
      current: `/grid?formId=${fromId}`,
      next: `/grid?formId=${fromId + length}`,
    },
  };
};

export const handlers = [
  rest.get(`${window.CRM_SPACE_API_HOST}/grid`, (req, res, ctx) => {
    const formId = Number.parseInt(req.url.searchParams.get('formId') ?? '');

    return res(ctx.json(generateData(Number.isNaN(formId) ? 1 : formId, 10)), ctx.delay(1000));
  }),

  rest.get(`${window.CRM_SPACE_API_HOST}/grid/error`, (req, res, ctx) => {
    return res(ctx.status(500), ctx.delay(1000));
  }),
];
